/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.LogWriter;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.util.Util;

public class GuiScriptList
extends SubGuiInterface
implements ICustomScrollListener {
    private final ScriptContainer container;
    private final Map<String, Long> scripts;
    private final Map<ResourceLocation, String> data = new TreeMap<ResourceLocation, String>();
    private GuiCustomScroll base;
    private GuiCustomScroll selected;
    private final String back = "   " + Character.toChars(8592)[0] + " (" + new TextComponentTranslation("gui.back", new Object[0]).func_150254_d() + ")";
    private String path = "";

    public GuiScriptList(Map<String, Long> scriptsList, ScriptContainer cont) {
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
        this.xSize = 346;
        this.ySize = 216;
        this.container = cont;
        if (scriptsList == null) {
            scriptsList = new TreeMap<String, Long>();
        }
        this.scripts = scriptsList;
        for (String path : this.scripts.keySet()) {
            ResourceLocation res = path.contains("/") ? new ResourceLocation(path.substring(0, path.lastIndexOf("/")), path.substring(path.lastIndexOf("/") + 1)) : new ResourceLocation("base", path);
            this.data.put(res, res.func_110623_a());
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                String file;
                if (!this.base.hasSelected()) {
                    return;
                }
                try {
                    file = this.base.getHoversTexts().get(this.base.getSelect()).get(0);
                }
                catch (Exception e) {
                    return;
                }
                this.container.scripts.add(file);
                this.base.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 2: {
                String file;
                if (!this.base.hasSelected()) {
                    return;
                }
                try {
                    file = this.selected.getHoversTexts().get(this.selected.getSelect()).get(0);
                }
                catch (Exception e) {
                    return;
                }
                this.container.scripts.remove(file);
                this.selected.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.container.scripts.clear();
                this.container.scripts.addAll(this.scripts.keySet());
                this.base.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.container.scripts.clear();
                this.base.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.base == null) {
            this.base = new GuiCustomScroll(this, 0);
            this.base.setSize(140, 180);
        }
        this.base.guiLeft = this.guiLeft + 4;
        this.base.guiTop = this.guiTop + 14;
        this.addScroll(this.base);
        this.addLabel(new GuiNpcLabel(1, "script.availableScripts", this.guiLeft + 4, this.guiTop + 4));
        if (this.selected == null) {
            this.selected = new GuiCustomScroll(this, 1);
            this.selected.setSize(140, 180);
        }
        this.selected.guiLeft = this.guiLeft + 200;
        this.selected.guiTop = this.guiTop + 14;
        this.addScroll(this.selected);
        this.addLabel(new GuiNpcLabel(2, "script.loadedScripts", this.guiLeft + 200, this.guiTop + 4));
        String p = ".../" + this.path;
        if (this.path.length() > 20) {
            p = "..." + this.path.substring(this.path.length() - 20);
        }
        this.addLabel(new GuiNpcLabel(3, "\u00a70\u00a7l" + p, this.guiLeft + 4, this.guiTop + 16 + this.base.field_146295_m));
        ArrayList<String> temp = new ArrayList<String>(this.scripts.keySet());
        temp.removeAll(this.container.scripts);
        TreeMap<String, Long> ds = new TreeMap<String, Long>();
        TreeMap fs = new TreeMap();
        TreeMap<String, Long> ft = new TreeMap<String, Long>();
        TreeMap<Object, String> hs = new TreeMap<Object, String>();
        ArrayList<String> listBase = new ArrayList<String>();
        ArrayList<Integer> colorsBase = new ArrayList<Integer>();
        ArrayList<String> suffixesBase = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        ArrayList<String> suffixes = new ArrayList<String>();
        char c = '\u00a7';
        int t = 1;
        if (!this.path.isEmpty()) {
            ds.put(this.back, 0L);
        }
        for (ResourceLocation res : this.data.keySet()) {
            Iterator key = this.data.get(res);
            boolean hasDir = !res.func_110624_b().equals("base");
            String file = (hasDir ? res.func_110624_b() + "/" : "") + res.func_110623_a();
            if (!temp.contains(file) && !this.container.scripts.contains(file)) continue;
            boolean isBase = temp.contains(file);
            if (isBase) {
                String folder;
                String string = folder = hasDir ? res.func_110624_b() : "";
                if (folder.isEmpty() && this.path.isEmpty()) {
                    fs.put(key, this.scripts.get(file));
                    hs.put(key, file);
                    continue;
                }
                if (folder.isEmpty()) continue;
                if (!this.path.isEmpty()) {
                    if (folder.indexOf(this.path) != 0) continue;
                    if ((folder = folder.replace(this.path, "")).indexOf("/") == 0) {
                        folder = folder.substring(1);
                    }
                }
                if (folder.contains("/")) {
                    folder = folder.substring(0, folder.indexOf("/"));
                }
                if (this.path.isEmpty() && !folder.isEmpty()) {
                    ds.put(folder, 0L);
                    hs.put(folder, folder);
                    continue;
                }
                if (folder.isEmpty()) {
                    fs.put(key, this.scripts.get(file));
                    hs.put(key, file);
                    continue;
                }
                ds.put(folder, 0L);
                hs.put(folder, this.path + "/" + folder);
                continue;
            }
            ft.put(c + "7" + t + ":" + c + "r " + key, this.scripts.get(file));
            hs.put(c + "7" + t + ":" + c + "r " + key, file);
            ++t;
        }
        LinkedHashMap<Integer, List<String>> htsB = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String key : ds.keySet()) {
            colorsBase.add(15973918);
            suffixesBase.add("");
            listBase.add(key);
            if (hs.containsKey(key)) {
                htsB.put(i, Collections.singletonList(hs.get(key)));
            }
            ++i;
        }
        for (String key : fs.keySet()) {
            long l = (Long)fs.get(key);
            colorsBase.add(l >= 0L ? 0xCAEAEA : 0xEAEACA);
            if (l < 0L) {
                l *= -1L;
            }
            String size = "" + l;
            if (l > 999L) {
                size = Util.instance.getTextReducedNumber(l, false, false, true);
            }
            suffixesBase.add(size + "b");
            listBase.add(key);
            if (hs.containsKey(key)) {
                if ((Long)fs.get(key) < 0L) {
                    ArrayList<Object> hl = new ArrayList<Object>();
                    hl.add(hs.get(key));
                    hl.add("\u00a74" + new TextComponentTranslation("gui.encrypted", new Object[0]).func_150254_d());
                    htsB.put(i, hl);
                } else {
                    htsB.put(i, Collections.singletonList(hs.get(key)));
                }
            }
            ++i;
        }
        LinkedHashMap<Integer, List<String>> htsS = new LinkedHashMap<Integer, List<String>>();
        i = 0;
        for (String key : ft.keySet()) {
            long l = (Long)ft.get(key);
            colors.add(l >= 0L ? 0xCAEAEA : 0xEAEACA);
            if (l < 0L) {
                l *= -1L;
            }
            String size = "" + l;
            if (l > 999L) {
                size = Util.instance.getTextReducedNumber(l, false, false, true);
            }
            suffixes.add(size + "b");
            list.add(key);
            if (hs.containsKey(key)) {
                if ((Long)ft.get(key) < 0L) {
                    ArrayList<Object> hl = new ArrayList<Object>();
                    hl.add(hs.get(key));
                    hl.add("\u00a74" + new TextComponentTranslation("gui.encrypted", new Object[0]).func_150254_d());
                    htsS.put(i, hl);
                } else {
                    htsS.put(i, Collections.singletonList(hs.get(key)));
                }
            }
            ++i;
        }
        this.base.setColors(colorsBase);
        this.base.setSuffixes(suffixesBase);
        this.base.setListNotSorted(listBase);
        this.base.setHoverTexts(htsB);
        this.selected.setColors(colors);
        this.selected.setSuffixes(suffixes);
        this.selected.setListNotSorted(list);
        this.selected.setHoverTexts(htsS);
        int x = this.guiLeft + 145;
        int y = this.guiTop + 40;
        this.addButton(new GuiNpcButton(1, x, y, 55, 20, ">", this.base.hasSelected()));
        this.addButton(new GuiNpcButton(2, x, y += 22, 55, 20, "<", this.selected.hasSelected()));
        this.addButton(new GuiNpcButton(3, x, y += 44, 55, 20, ">>", !temp.isEmpty()));
        this.addButton(new GuiNpcButton(4, x, y += 22, 55, 20, "<<", !this.container.scripts.isEmpty()));
        this.addButton(new GuiNpcButton(66, x, y + 46, 55, 20, "gui.done"));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            if (scroll.getSelected().equals(this.back)) {
                this.path = this.path.lastIndexOf("/") == -1 ? "" : this.path.substring(0, this.path.lastIndexOf("/"));
                this.base.setSelect(-1);
            } else if (scroll.getColor(scroll.getSelect()) == 15973918) {
                if (!this.path.isEmpty()) {
                    this.path = this.path + "/";
                }
                this.path = this.path + scroll.getSelected();
                this.base.setSelect(-1);
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        String file = "";
        try {
            file = scroll.getHoversTexts().get(scroll.getSelect()).get(0);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (file.isEmpty()) {
            return;
        }
        if (scroll.getID() == 0) {
            this.container.scripts.add(file);
            this.base.setSelect(-1);
            this.func_73866_w_();
        }
        if (scroll.getID() == 1) {
            this.container.scripts.remove(file);
            this.selected.setSelect(-1);
            this.func_73866_w_();
        }
    }
}

